#include <stdio.h>
#include <stdlib.h>

int cmp(const void *a, const void *b) {
    long long x = *(long long *)a;
    long long y = *(long long *)b;
    return (x > y) - (x < y);
}

int main() {
    int N;
    scanf("%d", &N);

    long long *S = malloc(N * sizeof(long long));
    long long *D = malloc(N * sizeof(long long));

    for (int i = 0; i < N; i++) {
        long long x, y;
        scanf("%lld %lld", &x, &y);
        S[i] = x + y;
        D[i] = x - y;
    }

    qsort(S, N, sizeof(long long), cmp);
    qsort(D, N, sizeof(long long), cmp);

    long long greetings = 0;

    for (int i = 0; i < N; ) {
        int j = i;
        while (j < N && S[j] == S[i]) j++;
        long long k = j - i;
        greetings += k * (k - 1);
        i = j;
    }

    for (int i = 0; i < N; ) {
        int j = i;
        while (j < N && D[j] == D[i]) j++;
        long long k = j - i;
        greetings += k * (k - 1);
        i = j;
    }

    printf("%lld\n", greetings);

    free(S);
    free(D);
    return 0;
}